#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgConfirmRelease
	/// </summary>
	public class DlgConfirmRelease : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private static string _separator = ". ";

		private ArrayList _comments;
		private string _techId;
		private System.DateTime _releaseDate;
		private VbecsUser [] _userArray;
		private bool _detailsRequired = false;

		#endregion

		#region Form Controls

		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.Label dd;
		private System.Windows.Forms.Label lblWarningMessage;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.GroupBox grpIcon;
		private System.Windows.Forms.PictureBox picWarning;
		private System.Windows.Forms.GroupBox grpUserInfo;
		private System.Windows.Forms.Label lblReleasedBy;
		private System.Windows.Forms.Label label1;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbReleasedBy;
		private System.Windows.Forms.DateTimePicker dtpReleaseDate;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgConfirmRelease));
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpComment = new System.Windows.Forms.GroupBox();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.dd = new System.Windows.Forms.Label();
			this.lblWarningMessage = new System.Windows.Forms.Label();
			this.txtComment = new System.Windows.Forms.TextBox();
			this.lblDetails = new System.Windows.Forms.Label();
			this.grpIcon = new System.Windows.Forms.GroupBox();
			this.picWarning = new System.Windows.Forms.PictureBox();
			this.grpUserInfo = new System.Windows.Forms.GroupBox();
			this.dtpReleaseDate = new System.Windows.Forms.DateTimePicker();
			this.cmbReleasedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.label1 = new System.Windows.Forms.Label();
			this.lblReleasedBy = new System.Windows.Forms.Label();
			this.grpComment.SuspendLayout();
			this.grpIcon.SuspendLayout();
			this.grpUserInfo.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(368, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Confirm Release";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 276);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(292, 260);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(212, 260);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpComment
			// 
			this.grpComment.AccessibleDescription = "Enter a comment before releasing the selected units";
			this.grpComment.AccessibleName = "Enter a comment before releasing the selected units";
			this.grpComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpComment.Controls.Add(this.cmbComment);
			this.grpComment.Controls.Add(this.dd);
			this.grpComment.Controls.Add(this.lblWarningMessage);
			this.grpComment.Controls.Add(this.txtComment);
			this.grpComment.Controls.Add(this.lblDetails);
			this.grpComment.Location = new System.Drawing.Point(60, 104);
			this.grpComment.Name = "grpComment";
			this.grpComment.Size = new System.Drawing.Size(304, 152);
			this.grpComment.TabIndex = 1;
			this.grpComment.TabStop = false;
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "Comment";
			this.cmbComment.AccessibleName = "Comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Interval = 100;
			this.cmbComment.Location = new System.Drawing.Point(68, 56);
			this.cmbComment.MaxLength = 80;
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(220, 22);
			this.cmbComment.TabIndex = 2;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// dd
			// 
			this.dd.Location = new System.Drawing.Point(8, 56);
			this.dd.Name = "dd";
			this.dd.Size = new System.Drawing.Size(60, 20);
			this.dd.TabIndex = 1;
			this.dd.Text = "Comment*";
			this.dd.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblWarningMessage
			// 
			this.lblWarningMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblWarningMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblWarningMessage.Location = new System.Drawing.Point(64, 12);
			this.lblWarningMessage.Name = "lblWarningMessage";
			this.lblWarningMessage.Size = new System.Drawing.Size(184, 32);
			this.lblWarningMessage.TabIndex = 0;
			this.lblWarningMessage.Text = "Enter a comment before releasing the selected unit(s).";
			this.lblWarningMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtComment
			// 
			this.txtComment.AccessibleDescription = "Details";
			this.txtComment.AccessibleName = "Details";
			this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComment.Location = new System.Drawing.Point(68, 84);
			this.txtComment.MaxLength = 255;
			this.txtComment.Multiline = true;
			this.txtComment.Name = "txtComment";
			this.txtComment.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtComment.Size = new System.Drawing.Size(220, 60);
			this.txtComment.TabIndex = 4;
			this.txtComment.Text = "";
			this.txtComment.TextChanged += new System.EventHandler(this.txtComment_TextChanged);
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(8, 84);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(60, 20);
			this.lblDetails.TabIndex = 3;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpIcon
			// 
			this.grpIcon.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpIcon.Controls.Add(this.picWarning);
			this.grpIcon.Location = new System.Drawing.Point(4, 32);
			this.grpIcon.Name = "grpIcon";
			this.grpIcon.Size = new System.Drawing.Size(52, 224);
			this.grpIcon.TabIndex = 5;
			this.grpIcon.TabStop = false;
			// 
			// picWarning
			// 
			this.picWarning.Image = ((System.Drawing.Image)(resources.GetObject("picWarning.Image")));
			this.picWarning.Location = new System.Drawing.Point(4, 12);
			this.picWarning.Name = "picWarning";
			this.picWarning.Size = new System.Drawing.Size(45, 45);
			this.picWarning.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picWarning.TabIndex = 0;
			this.picWarning.TabStop = false;
			// 
			// grpUserInfo
			// 
			this.grpUserInfo.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpUserInfo.Controls.Add(this.dtpReleaseDate);
			this.grpUserInfo.Controls.Add(this.cmbReleasedBy);
			this.grpUserInfo.Controls.Add(this.label1);
			this.grpUserInfo.Controls.Add(this.lblReleasedBy);
			this.grpUserInfo.Location = new System.Drawing.Point(60, 32);
			this.grpUserInfo.Name = "grpUserInfo";
			this.grpUserInfo.Size = new System.Drawing.Size(304, 72);
			this.grpUserInfo.TabIndex = 0;
			this.grpUserInfo.TabStop = false;
			// 
			// dtpReleaseDate
			// 
			this.dtpReleaseDate.AccessibleDescription = "Release Date";
			this.dtpReleaseDate.AccessibleName = "Release Date";
			this.dtpReleaseDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpReleaseDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpReleaseDate.Location = new System.Drawing.Point(88, 40);
			this.dtpReleaseDate.Name = "dtpReleaseDate";
			this.dtpReleaseDate.TabIndex = 3;
			this.dtpReleaseDate.ValueChanged += new System.EventHandler(this.dtpReleaseDate_ValueChanged);
			// 
			// cmbReleasedBy
			// 
			this.cmbReleasedBy.AccessibleDescription = "Release By";
			this.cmbReleasedBy.AccessibleName = "Release By";
			this.cmbReleasedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbReleasedBy.Interval = 500;
			this.cmbReleasedBy.Location = new System.Drawing.Point(88, 16);
			this.cmbReleasedBy.Name = "cmbReleasedBy";
			this.cmbReleasedBy.Size = new System.Drawing.Size(200, 22);
			this.cmbReleasedBy.TabIndex = 1;
			this.cmbReleasedBy.SelectedIndexChanged += new System.EventHandler(this.cmbReleasedBy_SelectedIndexChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 40);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(80, 20);
			this.label1.TabIndex = 2;
			this.label1.Text = "Release Date*";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblReleasedBy
			// 
			this.lblReleasedBy.Location = new System.Drawing.Point(8, 16);
			this.lblReleasedBy.Name = "lblReleasedBy";
			this.lblReleasedBy.Size = new System.Drawing.Size(80, 20);
			this.lblReleasedBy.TabIndex = 0;
			this.lblReleasedBy.Text = "Released By*";
			this.lblReleasedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgConfirmRelease
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(368, 292);
			this.Controls.Add(this.grpUserInfo);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpComment);
			this.Controls.Add(this.grpIcon);
			this.hlphelpChm.SetHelpKeyword(this, "Release_Units_From_Patient_Assignment.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(376, 319);
			this.Name = "DlgConfirmRelease";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Confirm Release";
			this.Load += new System.EventHandler(this.DlgConfirmRelease_Load);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpIcon, 0);
			this.Controls.SetChildIndex(this.grpComment, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpUserInfo, 0);
			this.grpComment.ResumeLayout(false);
			this.grpIcon.ResumeLayout(false);
			this.grpUserInfo.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// string Comment
		/// </summary>
		public string Comment
		{
			get 
			{	
				string comment = string.Empty;
				//
				if (this.cmbComment.SelectedIndex > -1)
				{
					if (this._detailsRequired)
					{
						comment	= this.txtComment.Text;
					}
					else
					{
						comment = this.cmbComment.Text;
						//
						if (this.txtComment.Text.Trim().Length > 0)
						{
							comment = string.Concat(comment, _separator, this.txtComment.Text);
						}
					}
				}
				return comment;	
			}
		} 		

		/// <summary>
		/// string TechId
		/// </summary>
		public string TechId
		{
			get 
			{
				return _techId;
			}
		} 		

		/// <summary>
		/// string Comments
		/// </summary>
		public System.DateTime ReleaseDate
		{
			get 
			{
				return _releaseDate;
			}
		} 		

		#endregion

		#region Constructors / Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgConfirmRelease()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();
			LoadCannedComments();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Methods

		/// <summary>
		/// void CheckIfDetailsRequired()
		/// </summary>
		private void CheckIfDetailsRequired()
		{
			// Details required if Comment = Other
			if (this.cmbComment.Text.Trim().ToUpper().Equals("OTHER"))
			{
				this.lblDetails.Text = "Details*";
				this._detailsRequired = true;
			}
			else
			{
				this.lblDetails.Text = "Details";
				this._detailsRequired = false;
			}
		}

		/// <summary>
		/// bool CheckValid()
		/// </summary>
		private bool CheckValid()
		{
			if (_detailsRequired)
			{
				return (this.txtComment.Text.Trim().Length > 0);
			}
			else
			{
				return (this.cmbComment.SelectedIndex > - 1);
			}
		}

		/// <summary>
		/// void LoadCannedComments()
		/// </summary>
		private void LoadCannedComments()
		{
			_comments = BOL.CannedComment.GetCannedCommentsList(Common.LogonUser.LogonUserDivisionCode, "RR");
			
			this.cmbComment.Items.Clear();

			foreach(Hashtable table in _comments)
			{
				this.cmbComment.Items.Add(table[Common.VbecsTables.CannedComment.CannedCommentText]);
			}
		}
		
		/// <summary>
		/// void PopulateControls()
		/// </summary>
		private void PopulateControls()
		{
			dtpReleaseDate.MaxDate = VBECSDateTime.GetDivisionCurrentDateTime();

			this.txtComment.Text = "";
			int logonUserIndex = -1;
		
			if (this._userArray == null || this._userArray.Length < 1)
			{
				ArrayList userList = BOL.VbecsUser.GetActiveDivisionUsers( Common.LogonUser.LogonUserDivisionCode );
				this._userArray = new BOL.VbecsUser[userList.Count];

				int index = 0;
				foreach (BOL.VbecsUser currentUser in userList)
				{
					cmbReleasedBy.Items.Add(currentUser.UserName);
					this._userArray[index] = currentUser;

					if (currentUser.UserNTLoginID.ToUpper().Equals(Common.LogonUser.LogonUserName.ToUpper()))
					{
						logonUserIndex = index;
					}

					index += 1;
				}
			}

			this.cmbReleasedBy.SelectedIndex = logonUserIndex;
		}

		/// <summary>
		/// Initialize user control properties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC047.DlgConfirmRelease());
			//
			//set custom date and time format
			this.dtpReleaseDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			this.dtpReleaseDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}

		/// <summary>
		/// Checks form data/controlls to see 
		/// if okay for submission.
		/// </summary>
		private void ValidateFormData()
		{
			this.CheckIfDetailsRequired();

			if (this.CheckValid() && cmbReleasedBy.SelectedIndex > -1 && !cmbReleasedBy.SelectedItem.ToString().Equals(string.Empty))
			{
				btnOK.Enabled = true;
				btnOK.EnabledButton = true;
			}
			else
			{
				btnOK.Enabled = false;
				btnOK.EnabledButton = false;
			}
		}

		#endregion

		#region Events

		/// <summary>
		/// void btnCancel_Click(object sender, System.EventArgs e)
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// void btnOK_Click(object sender, System.EventArgs e)
		/// </summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this._techId = this._userArray[cmbReleasedBy.SelectedIndex].UserNTLoginID;
			this._releaseDate = dtpReleaseDate.Value;
			this.DialogResult = DialogResult.Yes;

			this.IsDirty = false;
			this.Close();
		}

		/// <summary>
		/// void DlgConfirmRelease_Load(object sender, System.EventArgs e)
		/// </summary>
		private void DlgConfirmRelease_Load(object sender, System.EventArgs e)
		{
			this.PopulateControls();

			this.IsDirty = false;
		}

		/// <summary>
		/// void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		/// </summary>
		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			ValidateFormData();

			if (cmbComment.SelectedIndex > -1)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		/// <summary>
		/// void cmbReleasedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		/// </summary>
		private void cmbReleasedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			ValidateFormData();

			if (cmbReleasedBy.SelectedIndex > -1)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		/// <summary>
		/// void dtpReleaseDate_ValueChanged(object sender, System.EventArgs e)
		/// </summary>
		private void dtpReleaseDate_ValueChanged(object sender, System.EventArgs e)
		{
			ValidateFormData();

			this.SetDirtyFlag(sender, e);
		}
		/// <summary>
		/// void txtComment_TextChanged(object sender, System.EventArgs e)
		/// </summary>
		private void txtComment_TextChanged(object sender, System.EventArgs e)
		{
			ValidateFormData();

			if (txtComment.Text.Trim().Length > 0)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		#endregion
	}
}

